/******************************************************************************
 CMenuWindow.h

		Interface for the CMenuWindow Class
		
 ******************************************************************************/
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#pragma once

#include <CWindow.h>						/* Interface for its superclass		*/

	
class CMenuWindow : public CWindow {				/* Class Declaration		*/
protected:
		short	menuId;
		short	menuItem;
		long	cmdNo;	// command associated with this window
		Boolean	cmdInMenu;
public:
						// Don't change this name
			void		IWindow(short WINDid, Boolean aFloating,
							CDesktop *anEnclosure, CDirector *aSupervisor);
			void		INewWindow( Rect *bounds, Boolean fVisible, short procID,
							Boolean fFloating, Boolean fHasGoAway,
							CDesktop *anEnclosure, CDirector *aSupervisor);

			long		GetCmdNo(void);
			void		SetCmdNo(long command);
	virtual void		Dispose(void);
	virtual void		Close(void);
	virtual void		Show(void);
	virtual void		Select(void);

	virtual void		SetTitle(Str255 theTitle);

protected:
			void		RemoveFromMenu(void);
			void		AddToMenu(void);

};
